# delimit ;  
clear;
capture log close;
set more 1 ;  
*global folder "C:\research";
*global folder "C:\Users\Jeremy\Dropbox";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
*global folder "\\ad.ucl.ac.uk\homer\zctpmer\downloads";
global folder "D:\Dropbox\";
*global folder "\\econ-san-fs\Home4\uctpkp0\SystemFolder\Windows7\Desktop";
* set this to 1 if include 2020 wave;
global INCLUDE2020 1;



         local saved  "$folder\hrs\merge\";
         local trackd "$folder\hrs\tracker\";
         local wave1d "$folder\hrs\wave1\";
         local wave2d "$folder\hrs\wave2\";
         local wave3d "$folder\hrs\wave3\";
         local wave4d "$folder\hrs\wave4\";
         local wave5d "$folder\hrs\wave5\";
		 local wave6d "$folder\hrs\wave6\";
         local wave7d "$folder\hrs\wave7\";
         local wave8d "$folder\hrs\wave8\";
		 local wave9d "$folder\hrs\wave9\";
		 local wave10d "$folder\hrs\wave10\";
		 local wave11d "$folder\hrs\wave11\";
		 local wave12d "$folder\hrs\wave12\";
		 local wave13d "$folder\hrs\wave13\";
		 local wave14d "$folder\hrs\wave14\";
		 local wave15d "$folder\hrs\wave15\";
         local aheadw1 "$folder\hrs\aheadw1\";
         local aheadw2 "$folder\hrs\aheadw2\";



log using `saved'mortality.log, replace ;

clear;
set mem 100m;
use `trackd'TRK2020TR_R;
*use `trackd'TRK2016TR_R;
gen temp=real(HHID);
drop HHID;
gen HHID=temp;
drop temp;
gen temp=real(PN);
drop PN;
gen PN=temp;
drop temp;

********************* nobody in wave 1 has died yet **;
gen dead1=0;

********************* hrs wave 2 *********************;
gen dead2=.;
replace dead2=1 if (CALIVE==5|CALIVE==6);
replace dead2=0 if (CALIVE==1|CALIVE==2);

******************* ahead wave 2 ***********************;
gen adead2=.;
replace adead2=1 if (DALIVE==5|DALIVE==6);
replace adead2=0 if (DALIVE==1|DALIVE==2);

****************** hrs wave 3 ************************;
gen dead3=.;
replace dead3=1 if (EALIVE==5|EALIVE==6); 
replace dead3=0 if (EALIVE==1|EALIVE==2); 

******************* hrs wave 4 ***********************;
gen dead4=.;
replace dead4=1 if (FALIVE==5|FALIVE==6);
replace dead4=0 if (FALIVE==1|FALIVE==2);


***************** hrs wave5 *************************;
gen dead5=.;
replace dead5=1 if (GALIVE==5|GALIVE==6);
replace dead5=0 if (GALIVE==1|GALIVE==2);

***************** hrs wave6 *************************;
gen dead6=.;
replace dead6=1 if (HALIVE==5|HALIVE==6);
replace dead6=0 if (HALIVE==1|HALIVE==2);

***************** hrs wave7 *************************;
gen dead7=.;
replace dead7=1 if (JALIVE==5|JALIVE==6);
replace dead7=0 if (JALIVE==1|JALIVE==2);

***************** hrs wave8 *************************;
gen dead8=.;
replace dead8=1 if (KALIVE==5|KALIVE==6);
replace dead8=0 if (KALIVE==1|KALIVE==2);

***************** hrs wave9 *************************;
gen dead9=.;
replace dead9=1 if (LALIVE==5|LALIVE==6);
replace dead9=0 if (LALIVE==1|LALIVE==2);

***************** hrs wave10 *************************;
gen dead10=.;
replace dead10=1 if (MALIVE==5|MALIVE==6);
replace dead10=0 if (MALIVE==1|MALIVE==2);

***************** hrs wave11 *************************;
gen dead11=.;
replace dead11=1 if (NALIVE==5|NALIVE==6);
replace dead11=0 if (NALIVE==1|NALIVE==2);
***************** hrs wave12 *************************;
gen dead12=.;
replace dead12=1 if (OALIVE==5|OALIVE==6);
replace dead12=0 if (OALIVE==1|OALIVE==2);
***************** hrs wave13 *************************;
gen dead13=.;
replace dead13=1 if (PALIVE==5|PALIVE==6);
replace dead13=0 if (PALIVE==1|PALIVE==2);
***************** hrs wave14 *************************;
gen dead14=.;
replace dead14=1 if (QALIVE==5|QALIVE==6);
replace dead14=0 if (QALIVE==1|QALIVE==2);
if $INCLUDE2020 {; 
***************** hrs wave15 *************************;
gen dead15=.;
replace dead15=1 if (RALIVE==5|RALIVE==6);
replace dead15=0 if (RALIVE==1|RALIVE==2);
};

* if the respondent was dead last period, they are still dead this period;
replace dead3=dead2 if dead2==1;
replace dead4=1 if dead3==1|dead2==1;
replace dead5=1 if dead4==1|dead3==1|dead2==1;
replace dead6=1 if dead5==1|dead4==1|dead3==1|dead2==1;
replace dead7=1 if dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead8=1 if dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead9=1 if dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead10=1 if dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead11=1 if dead10==1|dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead12=1 if dead11==1 | dead10==1|dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead13=1 if dead12==1 | dead11==1 | dead10==1|dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
replace dead14=1 if dead13==1 | dead12==1 | dead11==1 | dead10==1|dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
if $INCLUDE2020 {; 
replace dead15=1 if dead14==1 | dead13==1 |dead12==1 | dead11==1 | dead10==1|dead9==1|dead8==1|dead7==1|dead6==1|dead5==1|dead4==1|dead3==1|dead2==1;
};



* replace AHEAD data here;
replace dead2=adead2 if dead2==.;

*Jon: Instead of using the HRS variable we generate our own sub1w1 later. ;
*gen sub1w1=real(ASUBHH);

gen sub2w2=real(CSUBHH);
gen sub3w3=real(ESUBHH);
gen sub4w4=real(FSUBHH);
gen sub5w5=real(GSUBHH);
gen sub6w6=real(HSUBHH);
gen sub7w7=real(JSUBHH);
gen sub8w8=real(KSUBHH);
gen sub9w9=real(LSUBHH);
gen sub10w10=real(MSUBHH);
gen sub11w11=real(NSUBHH);
gen sub12w12=real(OSUBHH);
gen sub13w13=real(PSUBHH);
gen sub14w14=real(QSUBHH);
if $INCLUDE2020 {; 
gen sub15w15=real(RSUBHH);
};

gen temp=real(DSUBHH);

/*
sort HHID PN;
order HHID PN sub* *SUB* dea*;
exit;


tab temp;
tab sub2w2;
sort sub2w2;
by sub2w2: sum temp sub2w2;
exit;
*/

*replace temp=sub4w4 if temp==9; *strikes me as dodgy--what will this do for the cohorts that enter in 1998 (and whose wave 2 sub hh id should equal 9);
replace sub2w2=temp if (sub2w2==.|sub2w2==9);



/*
*replace sub1w1=. if sub1w1==9; *Jon: ASUBHH only takes values 0 or 9, this means that there were not any sub households in the original survey. ;
replace sub2w2=. if sub2w2==3|sub2w2==4|sub2w2==9;
replace sub3w3=. if sub3w3==3|sub3w3==4|sub3w3==9;
replace sub4w4=. if sub4w4==3|sub4w4==4|sub4w4==9;
replace sub5w5=. if sub5w5==3|sub5w5==4|sub5w5==9;
replace sub6w6=. if sub6w6==3|sub6w6==4|sub6w6==9;
replace sub7w7=. if sub7w7==3|sub7w7==4|sub7w7==9;
replace sub8w8=. if sub8w8==3|sub8w8==4|sub8w8==9;
replace sub9w9=. if sub9w9==3|sub9w9==4|sub9w9==9;
*/

* wave 1 sub hh id was never coded, but this should work;
gen sub1w1=0; 
replace sub1w1=1 if (PN~=10 & PN~=20 & PN~=30 & PN~=40);  * a non-original sample member will not have a person number that ends in a '0';



* sometimes people are 3s or 4s for several waves (ie, they are "just dead" for several waves);
replace sub3w3=9 if sub2w2==3|sub2w2==4;
replace sub4w4=9 if sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub5w5=9 if sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub6w6=9 if sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub7w7=9 if sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub8w8=9 if sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub9w9=9 if sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub10w10=9 if sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub11w11=9 if sub10w10==3|sub10w10==4|sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub12w12=9 if sub11w11==3 | sub11w11==4 |sub10w10==3|sub10w10==4|sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub13w13=9 if sub12w12==3 | sub12w12==4 |sub11w11==3 | sub11w11==4 |sub10w10==3|sub10w10==4|sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
replace sub14w14=9 if sub13w13==3 | sub13w13==4 | sub12w12==3 | sub12w12==4 |sub11w11==3 | sub11w11==4 |sub10w10==3|sub10w10==4|sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
if $INCLUDE2020 {; 
replace sub15w15=9 if sub14w14==3 | sub14w14==4 | sub13w13==3 | sub13w13==4 | sub12w12==3 | sub12w12==4 |sub11w11==3 | sub11w11==4 |sub10w10==3|sub10w10==4|sub9w9==3|sub9w9==4|sub8w8==3|sub8w8==4|sub7w7==3|sub7w7==4|sub6w6==3|sub6w6==4|sub5w5==3|sub5w5==4|sub4w4==3|sub4w4==4|sub3w3==3|sub3w3==4|sub2w2==3|sub2w2==4;
};


* give dead spouses the subhhid they had last wave.  this way we can merge them in with their spouse;
replace sub2w2=sub1w1 if sub2w2==3|sub2w2==4;

replace sub3w3=sub2w2 if (sub3w3==3|sub3w3==4) & sub2w2~=9;
replace sub3w3=sub1w1 if (sub3w3==3|sub3w3==4) & sub2w2==9;

replace sub4w4=sub3w3 if (sub4w4==3|sub4w4==4) & sub3w3~=9;
replace sub4w4=sub2w2 if (sub4w4==3|sub4w4==4) & sub3w3==9;
replace sub4w4=sub1w1 if (sub4w4==3|sub4w4==4) & (sub3w3==9 & sub2w2==9);

replace sub5w5=sub4w4 if (sub5w5==3|sub5w5==4) & sub4w4~=9;
replace sub5w5=sub3w3 if (sub5w5==3|sub5w5==4) & sub4w4==9;

replace sub6w6=sub5w5 if (sub6w6==3|sub6w6==4) & sub5w5~=9;
replace sub6w6=sub4w4 if (sub6w6==3|sub6w6==4) & sub5w5==9;

replace sub7w7=sub6w6 if (sub7w7==3|sub7w7==4) & sub6w6~=9;
replace sub7w7=sub5w5 if (sub7w7==3|sub7w7==4) & sub6w6==9;

replace sub8w8=sub7w7 if (sub8w8==3|sub8w8==4) & sub7w7~=9;
replace sub8w8=sub6w6 if (sub8w8==3|sub8w8==4) & sub7w7==9;

replace sub9w9=sub8w8 if (sub9w9==3|sub9w9==4) & sub8w8~=9;
replace sub9w9=sub7w7 if (sub9w9==3|sub9w9==4) & sub8w8==9;

replace sub10w10=sub9w9 if (sub10w10==3|sub10w10==4) & sub9w9~=9;
replace sub10w10=sub8w8 if (sub10w10==3|sub10w10==4) & sub9w9==9;


replace sub11w11=sub10w10 if (sub11w11==3|sub11w11==4) & sub10w10~=9;
replace sub11w11=sub9w9 if (sub11w11==3|sub11w11==4) & sub10w10==9;

replace sub12w12=sub11w11 if (sub12w12==3|sub12w12==4) & sub11w11~=9;
replace sub12w12=sub10w10 if (sub12w12==3|sub12w12==4) & sub11w11==9;

replace sub13w13=sub12w12 if (sub13w13==3|sub13w13==4) & sub12w12~=9;
replace sub13w13=sub11w11 if (sub13w13==3|sub13w13==4) & sub12w12==9;

replace sub14w14=sub13w13 if (sub14w14==3|sub14w14==4) & sub13w13~=9;
replace sub14w14=sub12w12 if (sub14w14==3|sub14w14==4) & sub13w13==9;
if $INCLUDE2020 {; 
replace sub15w15=sub14w14 if (sub15w15==3|sub15w15==4) & sub14w14~=9;
replace sub15w15=sub13w13 if (sub15w15==3|sub15w15==4) & sub14w14==9;
};

*Jon: Uncomment the following line if the HRS variable is used, instead of the "sub1w1" variable we created.;
*replace sub1w1=. if sub1w1==9;
replace sub2w2=. if sub2w2==9;
replace sub3w3=. if sub3w3==9;
replace sub4w4=. if sub4w4==9;
replace sub5w5=. if sub5w5==9;
replace sub6w6=. if sub6w6==9;
replace sub7w7=. if sub7w7==9;
replace sub8w8=. if sub8w8==9;
replace sub9w9=. if sub9w9==9;
replace sub10w10=. if sub10w10==9;
replace sub11w11=. if sub11w11==9;
replace sub12w12=. if sub12w12==9;
replace sub13w13=. if sub13w13==9;
replace sub14w14=. if sub14w14==9;
* setting SUBHH to previous wave for recently dead (as above) causes problems if spouse remarries in the same wave as the person dies,
* so here the dead spouse has SUBHH set to missing. ;
if $INCLUDE2020 {; 
replace sub15w15=. if sub15w15==9;
};

local wvend 14;
if $INCLUDE2020 {; 
	local wvend 15;
};


forval i=2/`wvend'  {;
egen group=group(HHID sub`i'w`i');
sort group;
by group: gen num`i'=_N;
drop group;
replace sub`i'w`i'=. if dead`i'==1 & num`i'==3;
};


/*
replace sub2w2=. if sub2w2==3|sub2w2==4|sub2w2==9;
replace sub3w3=. if sub3w3==3|sub3w3==4|sub3w3==9;
replace sub4w4=. if sub4w4==3|sub4w4==4|sub4w4==9;
replace sub5w5=. if sub5w5==3|sub5w5==4|sub5w5==9;
replace sub6w6=. if sub6w6==3|sub6w6==4|sub6w6==9;
replace sub7w7=. if sub7w7==3|sub7w7==4|sub7w7==9;
replace sub8w8=. if sub8w8==3|sub8w8==4|sub8w8==9;
replace sub9w9=. if sub9w9==3|sub9w9==4|sub9w9==9;

replace sub2w2=. if sub2w2==3|sub2w2==4;
replace sub3w3=. if sub3w3==3|sub3w3==4;
replace sub4w4=. if sub4w4==3|sub4w4==4;
replace sub5w5=. if sub5w5==3|sub5w5==4;
replace sub6w6=. if sub6w6==3|sub6w6==4;
replace sub7w7=. if sub7w7==3|sub7w7==4;
replace sub8w8=. if sub8w8==3|sub8w8==4;
replace sub9w9=. if sub9w9==3|sub9w9==4;
*/
tab temp sub2w2;

*keep dead* sub* NAMONTH NAYEAR HHID PN;

keep dead* sub* HHID PN;


sort HHID PN;
save `saved'mortality, replace;
*clear;
log close;
* compare summary stats before and after;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(mortality.xlsx) replace;
cd "$folder\hrs\merge\" ;
use `saved'mortality.old.dta , clear;
cd "$folder\hrs\merge\compare\" ;
summtab, contvars(_all) mean median range excel excelname(mortality.xlsx) sheetname(Old);


